// ---------- Definition ----------
typedef unsigned __int16 __uint16;
typedef unsigned __int32 __uint32;
typedef unsigned __int8  __uint8 ;
typedef unsigned int     uint ;
typedef unsigned char    uchar;

#define dReadMemUint8()        (*(__uint8  *)pReadDataIdx);  pReadDataIdx +=1;
#define dReadMemUint16()       (*(__uint16 *)pReadDataIdx);  pReadDataIdx +=2;
#define dReadMemUint32()       (*(__uint32 *)pReadDataIdx);  pReadDataIdx +=4;
#define dReadMemSint8()        (*(__int8   *)pReadDataIdx);  pReadDataIdx +=1;
#define dReadMemSint16()       (*(__int16  *)pReadDataIdx);  pReadDataIdx +=2;
#define dReadMemSint32()       (*(__int32  *)pReadDataIdx);  pReadDataIdx +=4;
#define dReadMemFloat()        (*(float    *)pReadDataIdx);  pReadDataIdx +=4;
#define dReadMemString(str)    (len=(__int32 *)pReadDataIdx);pReadDataIdx +=4; str=new char[(*len)+1]; strncpy(str,pReadDataIdx,(*len)); pReadDataIdx +=(*len);
#define dReadMemNString(str,n) strncpy(str,pReadDataIdx, n); pReadDataIdx +=n;

#define dWriteMemUint8(val)     (*(__uint8  *)pWriteDataIdx) =val;  pWriteDataIdx +=1;
#define dWriteMemUint16(val)    (*(__uint16 *)pWriteDataIdx) =val;  pWriteDataIdx +=2;
#define dWriteMemUint32(val)    (*(__uint32 *)pWriteDataIdx) =val;  pWriteDataIdx +=4;
#define dWriteMemSint8(val)     (*(__int8   *)pWriteDataIdx) =val;  pWriteDataIdx +=1;
#define dWriteMemSint16(val)    (*(__int16  *)pWriteDataIdx) =val;  pWriteDataIdx +=2;
#define dWriteMemSint32(val)    (*(__int32  *)pWriteDataIdx) =val;  pWriteDataIdx +=4;
#define dWriteMemFloat(val)     (*(float    *)pWriteDataIdx) =val;  pWriteDataIdx +=4;
#define dWriteMemString(str)    (len=strlen(str); (*(__uint32 *)pWriteDataIdx) =len; pWriteDataIdx +=4; strncpy(pWriteDataIdx,str,len); pWriteDataIdx +=len;
#define dWriteMemNString(str,n) strncpy(pWriteDataIdx,str, n); pWriteDataIdx +=n;

